--[[---------------------------------------------------------------------------
	Chocolatier Two Simulator: Speakeasy
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

require("sim/building.lua")

-- Speakeasy class definition, derived from LBuilding
LSpeakeasy = LBuilding:subclass
{
	__tostring = function(t) return "{Speakeasy:" .. tostring(t.name) .. "}" end,
}

-------------------------------------------------------------------------------
-- Functions for data description

function Speakeasy(t) return LSpeakeasy:new(t) end

-------------------------------------------------------------------------------
-- "constructor"

function LSpeakeasy:new(t)
	t.character = t.rank0
	t = LBuilding.new(self, t)
	return t
end

-------------------------------------------------------------------------------
-- Building interaction

function LSpeakeasy:OnActivate()
	-- Determine character list based on player's current rank
	self.character = self.rank0 or self.character
	if gSim.rank > 0 then self.character = self.rank1 or self.character end
	if gSim.rank > 1 then self.character = self.rank2 or self.character end
	if gSim.rank > 2 then self.character = self.rank3 or self.character end
	if gSim.rank > 3 then self.character = self.rank4 or self.character end
	if gSim.rank > 4 then self.character = self.rank5 or self.character end
	LBuilding.OnActivate(self)
end
